% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{archive_estimation}
\alias{archive_estimation}
\title{Archive Estimation Results}
\usage{
archive_estimation(name, cfg)
}
\arguments{
\item{name}{analysis name}

\item{cfg}{ubiquity system object}
}
\value{
Boolean variable indicating success (\code{TRUE}) or failure (\code{FALSE})
}
\description{
Archives the estimation results by moving the output files to the same file
 names with \code{'name'} prepended to them. This prevents them from being
 overwritten in a different analysis script the following files are
 archived:
 \itemize{
  \item \code{output/parameters_all.csv}
  \item \code{output/parameters_est.csv}
  \item \code{output/report.txt}
 }
 Example:

  archive_estimation('mysoln', cfg)

Would rename the files above 
 \itemize{
  \item \code{output/mysoln-parameters_all.csv}
  \item \code{output/mysoln-parameters_est.csv}
  \item \code{output/mysoln-report.txt}
 }
}
\keyword{internal}
