% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_report_doc_add_content}
\alias{system_report_doc_add_content}
\title{Add content to Body of a Word Document Report}
\usage{
system_report_doc_add_content(cfg, rptname = "default",
  content_type = NULL, content = NULL)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{rptname}{report name initialized with \code{system_report_init}}

\item{content_type}{name of the placeholder}

\item{content}{list containing content to add 

For each content type listed below the following content is expected:

\itemize{
 \item \code{"text"} text string of information
 \item \code{"list"} vector of paired values (indent level and text), eg.  c(1, "Main Bullet", 2 "Sub Bullet")
 \item \code{"imagefile"} image from a file
  \itemize{
     \item \code{image} string containing path to image file
     \item \code{caption} Text containing the caption of the image
   }
 \item \code{"ggplot"} ggplot object, eg. p = ggplot() + ....
  \itemize{
     \item \code{image} ggplot object
     \item \code{caption} Text containing the caption of the image
   }
 \item \code{"table"} list containing the table content and other options with the following elements (defaults in parenthesis):
  \itemize{
     \item \code{table} Data frame containing the tabular data
     \item \code{caption} Text containing the caption of the table 
     \item \code{header} Boolean variable to control displaying the header (\code{TRUE})
     \item \code{first_row} Boolean variable to indicate that the first row contains header information (\code{TRUE})
   }
}}
}
\value{
cfg ubiquity system object with the content added to the body
}
\description{
Appends content to the body of a word document

For example if you have <HEADER_LEFT> in the header of your document and you wanted to
replace it with the text "Upper left" you would do the following:

\code{
  cfg = system_report_doc_set_ph(cfg, 
        ph_content  = "Upper Left" ,
        ph_name     = "HEADER_LEFT", 
        ph_location = "header")}

Notice the \code{ph_name} just has \code{HEADER_LEFT} and leaves off the \code{<>}
}
