% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{calc_performance_metrics}
\alias{calc_performance_metrics}
\title{Calculates performance metrics of a business-as-usual model}
\usage{
calc_performance_metrics(predictions, date_effect_start = NULL, buffer = 0)
}
\arguments{
\item{predictions}{data.table or data.frame with the following columns
\describe{
\item{date}{Date of the observation. Needs to be comparable to
date_effect_start element.}
\item{value}{True observed value of the station}
\item{prediction}{Predicted model output for the same time and station
as value}
\item{prediction_lower}{Lower end of the prediction interval}
\item{prediction_upper}{Upper end of the prediction interval}
}}

\item{date_effect_start}{A date. Start date of the
effect that is to be evaluated. The data from this point onwards is disregarded
for calculating model performance}

\item{buffer}{Integer. An additional buffer window before date_effect_start to account
for uncertainty in the effect start point. Disregards additional buffer data
points for model evaluation}
}
\value{
Named vector with performance metrics of the model
}
\description{
Model agnostic function to calculate a number of common performance
metrics on the reference time window.
Uses the true data \code{value} and the predictions \code{prediction} for this calculation.
The coverage is calculated from the columns \code{value}, \code{prediction_lower} and
\code{prediction_upper}.
Removes dates in the effect and buffer range as the model is not expected to
be performing correctly for these times. The incorrectness is precisely
what we are using for estimating the effect.
}
