% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\name{plot.gsmarpred}
\alias{plot.gsmarpred}
\title{plot method for class 'gsmarpred' objects}
\usage{
\method{plot}{gsmarpred}(x, ..., nt, add_grid = TRUE)
}
\arguments{
\item{x}{object of class \code{'gsmarpred'} generated by \code{predict.gsmar()}.}

\item{...}{arguments passed to \code{grid()}}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction. Default is \code{round(length(data)*0.2)}.}

\item{add_grid}{should grid be added to the plots?}
}
\description{
\code{plot.gsmarpred} is plot method for gsmarpred objects
}
\details{
This method is used plot forecasts of gsmar processes
}
\examples{
 \donttest{
 # GMAR-model
 params12 <- c(1.12321, 0.90557, 0.29288, 4.53131,
               0.70309, 3.21154, 0.83888)
 gmar12 <- GSMAR(VIX, 1, 2, params12)
 pred <- predict(gmar12, n_ahead=10, plotRes=FALSE)
 plot(pred, nt=50)
 }
}
