% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{highlight_substance}
\alias{highlight_substance}
\title{Highlight a selected substance}
\usage{
highlight_substance(
  x,
  dst_cluster,
  new = TRUE,
  clusternames = NULL,
  polygon_color = "red",
  match_uFTIR = FALSE,
  ...
)
}
\arguments{
\item{x}{"clipper" object to plot}

\item{dst_cluster}{cluster (or substance) to highlight. Numeric and character inputs are supported. If is char, then you should provide clusternames to coerse it to numeric.}

\item{new}{Do you want a new plot or the function should add the polygons to the current plot?}

\item{clusternames}{char vector given the list of analyzed substance clusters. Only relevant when dst_cluster is a character.}

\item{polygon_color}{color of the overploted polygons. Red by default.}

\item{match_uFTIR}{The Agilent Microscope transposes and inverts the image (it inverts rows only -cols after transposition). Do you want the plot function to match this behaviour? Default FALSE.}

\item{...}{other arguments for \code{\link{plot_tile}}}
}
\value{
A function that plots and returns NULL.
}
\description{
The function highlights a selected substance(s) -or cluster(s)- in a plot. It can add to an existing plot or create a new one. Currently implemented only for S3 objects returned by \code{\link{clipper}}.
}
\examples{
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- tile_base_corr(x)
x <- wavealign(x, primpke)
x <- tile_sam(x)
x <- smooth_sam(x, as.integer(length(primpke@clusternames)), window = 3, 1)
clip <- toClip(8,20,c(10,10))
plot(x)
polygon(clip@xycoords)
x <- clipper(x, clip@centre, clip@rad, 1)

highlight_substance(x, 5)
}
