twFromJSON <- function(json) {
    ## Will provide some basic error checking, as well as suppress
    ## warnings that always seem to come out of fromJSON, even in good cases.
    out <- try(suppressWarnings(fromJSON(json)), silent=TRUE)
    if (inherits(out, "try-error")) {
        stop("Error: Malformed response from server, was not JSON")
    }
    if (length(out) == 2) {
        names <- names(out)
        if ((!is.null(names))&&(all(names(out) == c("request", "error"))))
            stop("Error: ", out$error)
    }
    out
}

buildDM <- function(json) {
    sender <- buildUser(json[['sender']])
    recip <- buildUser(json[['recipient']])
    if (is.null(json$text))
        json$text <- character()
    if (is.null(json$"recipient_id"))
        json[['recipient_id']] <- numeric()
    if (is.null(json[['sender_id']]))
        json[['sender_id']] <- numeric()
    if (is.null(json[['sender_screen_name']]))
        json[['sender_screen_name']] <- character()
    if (is.null(json[['created_at']]))
        json[['created_at']] <- character()
    if (is.null(json[['recipient_screen_name']]))
        json[['recipient_screen_name']] <- character()
    if (is.null(json[['id']]))
        json[['id']] <- numeric()
    new("directMessage",
        text=json[['text']],
        recipientSN=json[['recipient_screen_name']],
        created=json[['created_at']],
        recipientID=json[['recipient_id']],
        sender=sender,
        recipient=recip,
        senderID=json[['sender_id']],
        id=json[['id']],
        senderSN=json[['sender_screen_name']]
        )
}

buildUser <- function(json) {
    status <- buildStatus(json[['status']])

    if ((is.null(json$description))||(is.na(json$description)))
        json$description <- character()
    if (is.null(json$"statuses_count"))
        json$"statuses_count" <- numeric()
    if (is.null(json$"followers_count"))
        json$"followers_count" <- numeric()
    if (is.null(json$"friends_count"))
        json$"friends_count" <- numeric()
    if ((is.null(json$url))||(is.na(json$url)))
        json$url <- character()
    if (is.null(json$name))
        json$name <- character()
    if (is.null(json$"created_at"))
        json$"created_at" <- character()
    if (is.null(json$protected))
        json$protected <- TRUE
    if (is.null(json$verified))
        json$verified <- FALSE
    if (is.null(json$"screen_name"))
        json$"screen_name" <- character()
    if ((is.null(json$location))||(is.na(json$location)))
        json$location <- character()
    if (is.null(json$id))
        json$id <- numeric()

    new("user",
        description=json$description,
        statusesCount=json$"statuses_count",
        followersCount=json$"followers_count",
        friendsCount=json$"friends_count",
        url=json$url,
        name=json$name,
        created=json$"created_at",
        protected=json$protected,
        verified=json$verified,
        screenName=json$"screen_name",
        location=json$location,
        id=json$id,
        lastStatus=status
        )
}

buildStatus <- function(json) {
    if (!is.list(json))
        return(new("status"))

    if ('user' %in% names(json)) {
        user <- buildUser(json[['user']])
        screenName <- screenName(user)
    }
    else if ('from_user' %in% names(json)) {
        screenName <- json$from_user
    }
    else {
        screenName <- "Unknown"
    }

    if ((is.null(json$"in_reply_to_screen_name"))||(is.na(json$"in_reply_to_screen_name")))
        json$"in_reply_to_screen_name" <- character()
    if ((is.null(json$"in_reply_to_status_id"))||(is.na(json$"in_reply_to_status_id")))
        json$"in_reply_to_status_id" <- numeric()
    if ((is.null(json$"in_reply_to_user_id"))||(is.na(json$"in_reply_to_user_id")))
        json$"in_reply_to_user_id" <- numeric()

    if (is.null(json$text))
        json$text <- character()
    if (is.null(json$favorited))
        json$favorited <- FALSE
    if (is.null(json$truncated))
        json$truncated <- FALSE
    if (is.null(json$source))
        json$source <- character()
    if (is.null(json$"created_at"))
        json$"created_at" <- character()
    if (is.null(json$id))
        json$id <- numeric()

    new("status",
        text=json$text,
        favorited=json$favorited,
        replyToSN=json$"in_reply_to_screen_name",
        created=json$"created_at",
        truncated=json$truncated,
        replyToSID=json$"in_reply_to_status_id",
        id=json$id,
        replyToUID=json$"in_reply_to_user_id",
        statusSource=json$source,
        screenName=screenName)
}
