% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restartTuneRanger.R
\name{restartTuneRanger}
\alias{restartTuneRanger}
\title{restartTuneRanger}
\usage{
restartTuneRanger(save.file.path = "optpath.RData", task,
  measure = NULL)
}
\arguments{
\item{save.file.path}{File name in the current working directory to which interim results were saved by \code{\link{tuneRanger}}.}

\item{task}{The mlr task created by \code{\link[mlr]{makeClassifTask}} or \code{\link[mlr]{makeRegrTask}}.}

\item{measure}{Performance measure that was already used in the original \code{\link{tuneRanger}} process.}
}
\value{
A list with elements
  \item{\code{recommended.pars}}{Recommended hyperparameters.}
  \item{\code{results}}{A data.frame with all evaluated hyperparameters and performance and time results for each run.}
No model is build.
}
\description{
Restarts the tuning process if an error occured.
}
\examples{
\dontrun{
library(tuneRanger)
library(mlr)

# iris is a bit nonsense here
# A mlr task has to be created in order to use the package
# the already existing iris task is used here
estimateTimeTuneRanger(iris.task)
# temporarily file name to save results
path = tempfile()
res = tuneRanger(iris.task, measure = list(multiclass.brier), num.trees = 1000, 
  num.threads = 8, iters = 70, save.file.path = path)

# Mean of best 5 \% of the results
res

# Restart after failing in one of the iterations:
res = restartTuneRanger(save.file.path = path, iris.task, 
measure = list(multiclass.brier))}
}
