% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortfall_de.R
\name{shortfall_de_test}
\alias{shortfall_de_test}
\alias{shortfall_test}
\title{Expected Shortfall DE Test}
\usage{
shortfall_de_test(x, alpha = 0.05, lags = 1, boot = FALSE, n_boot = 2000, ...)
}
\arguments{
\item{x}{the probability integral transformed series (pit).}

\item{alpha}{the quantile level for calculating the forecast value at risk
and expected shortfall.}

\item{lags}{the numbers of lags to use for the conditional test.}

\item{boot}{whether to use bootstrap simulation for estimating the p-values.}

\item{n_boot}{the bootstrap replications used to calculate the p-value.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tstest.shortfall_de} which has a print and
as_flextable method.
}
\description{
The expected shortfall test of Du and Escanciano (2017).
}
\details{
The test of Du and Escanciano (2017) combines ideas from
Berkowitz (2001) and Christoffersen (1998) to create an unconditional
and conditional shortfall test based on the probability integral transformed
actuals conditioned on the forecast distribution to evaluate the severity
and independence of the residuals shortfall (based on violations of VaR).
The unconditional test (severity) checks for the mean of cumulative violations using
a t-test, whilst the conditional test (independence) is a Portmanteau test applied to
estimated cumulative violations. A bootstrap approach to calculating the
distribution of the test statistics is available for finite samples, similar
to the suggestions of McNeil (2000).
}
\examples{
library(tsdistributions)
data("garch_forecast")
x <- pdist("jsu", q = garch_forecast$actual, mu = garch_forecast$forecast,
sigma = garch_forecast$sigma, skew = garch_forecast$skew,
shape = garch_forecast$shape)
print(shortfall_de_test(x, alpha = 0.05, lags = 4))

}
\references{
\insertRef{Du2017}{tstests}

\insertRef{Berkowitz2001}{tstests}

\insertRef{Christoffersen1998}{tstests}

\insertRef{McNeil2000}{tstests}
}
