% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrimp.R
\name{scrimp}
\alias{scrimp}
\title{Anytime univariate SCRIMP algorithm (experimental)}
\usage{
scrimp(..., window_size, exclusion_zone = 1/2, verbose = 2,
  s_size = Inf)
}
\arguments{
\item{...}{a \code{matrix} or a \code{vector}.}

\item{window_size}{an \code{int}. Size of the sliding window.}

\item{exclusion_zone}{a \code{numeric}. Size of the exclusion zone, based on window size (default is
\code{1/2}). See details.}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}

\item{s_size}{a \code{numeric}. for anytime algorithm, represents the size (in observations) the
random calculation will occur (default is \code{Inf}).}
}
\value{
Returns a \code{MatrixProfile} object, a \code{list} with the matrix profile \code{mp}, profile index \code{pi}
left and right matrix profile \code{lmp}, \code{rmp} and profile index \code{lpi}, \code{rpi}, window size \code{w} and
exclusion zone \code{ez}.
}
\description{
Computes the best so far Matrix Profile and Profile Index for Univariate Time Series.
DISCLAIMER: This algorithm still in development by its authors.
Join similarity, RMP and LMP not implemented yet.
}
\details{
The Matrix Profile, has the potential to revolutionize time series data mining because of its
generality, versatility, simplicity and scalability. In particular it has implications for time
series motif discovery, time series joins, shapelet discovery (classification), density
estimation, semantic segmentation, visualization, rule discovery, clustering etc. The anytime
SCRIMP computes the Matrix Profile and Profile Index in such manner that it can be stopped before
its complete calculation and return the best so far results allowing ultra-fast approximate
solutions. \code{verbose} changes how much information is printed by this function; \code{0} means nothing,
\code{1} means text, \code{2} means text and sound. \code{exclusion_zone} is used to avoid  trivial matches.
}
\examples{
mp <- scrimp(mp_toy_data$data[1:200, 1], window_size = 30, verbose = 0)

\dontrun{
ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 2]
# self similarity
mp <- scrimp(ref_data, window_size = 30, s_size = round(nrow(ref_data) * 0.1))
# join similarity
mp <- scrimp(ref_data, query_data, window_size = 30, s_size = round(nrow(query_data) * 0.1))
}
}
\references{
Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other matrix profile computations: \code{\link{mstomp_par}},
  \code{\link{stamp_par}}, \code{\link{stomp_par}},
  \code{\link{tsmp}}
}
\concept{matrix profile computations}
