\name{tsal.test}
\alias{tsal.test}
\alias{test.tsal.quantile.transform}
\alias{test.tsal.LR.distribution}

\title{Test Tsallis Distributions}
\description{
  Test functions.
}
\usage{
test.tsal.quantile.transform(from=0, to=1e6, shape=1, scale=1,
    q=tsal.q.from.shape(shape), kappa=tsal.kappa.from.ss(shape,scale),
    n=1e5, lwd=0.01, xmin=0, ...)

test.tsal.LR.distribution(n=100, reps=100, shape=1, scale=1,
    q=tsal.q.from.shape(shape), kappa=tsal.kappa.from.ss(shape,scale),
    xmin=0,method="mle.equation",...)

}
\arguments{

\item{from}{lower limit for \code{x}.}
\item{to}{upper limit for \code{x}.}
\item{shape, q}{shape parameters.}
\item{scale, kappa}{scale parameters.  If we have both shape/scale and q/kappa parameters, the latter over-ride.}
\item{n}{number of points at which to evaluate the function over the domain
or number of sample points.}
\item{lwd}{line width.}
\item{xmin}{minimum x-value (left-censoring threshold).}
\item{\dots}{further arguments to be passed to \code{\link{curve}} or \code{\link{plot}},
except \code{xlim} for \code{test.tsal.LR.distribution}.}
\item{reps}{number of replicates.}
\item{method}{estimation method, see \code{\link{tsal.fit}}.}

}
\details{
\code{plot.tsal.quantile.transform} check the accuracy of quantile/inverse quantile transformations
For all parameter values and all \code{x}, \code{qtsal(ptsal(x))} should \code{= x}.
 This function displays the relative error in the transformation, which is due
 to numerical imprecision.  This indicates roughly how far off random variates
 generated by the transformation method will be.
 If everything is going according to plan, the curve plotted should oscillate
 extremely rapidly between positive and negative limits which, while growing,
 stay quite small in absolute terms, e.g., on the order of 1e-5 when
\code{x} is on the order of 1e9.

\code{plot.tsal.LR.distribution}
checks likelihood ratio estimation accuracy :
\eqn{ 2*[(Likelihood at estimated parameters) - (likelihood at true parameters)]}
 should have a chi square distribution with 2 degrees of freedom, at least
 asymptotically for large samples.

}
\value{
\code{plot.tsal.quantile.transform} plots the relative error in the transformation.

\code{plot.tsal.LR.distribution} plots the likelihood ratio against a
chi-square distribution and returns the result of Kolmgorov-Smirnov
test against theoretical distribution.
}

\references{

\emph{Maximum Likelihood Estimation for q-Exponential (Tsallis) Distributions},
\url{http://bactra.org/research/tsallis-MLE/} and \url{http://arxiv.org/abs/math.ST/0701854}.


}
\author{
Cosma Shalizi (original R code),
Christophe Dutang (R packaging)

}
\examples{

#####
# (1) fit
x <- rtsal(20, 1/2, 1/4)
tsal.loglik(x, 1/2, 1/4)

tsal.fit(x, method="mle.equation")
tsal.fit(x, method="mle.direct")
tsal.fit(x, method="leastsquares")



		
}
\keyword{distribution}
