% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_to_net.R
\name{tsnet_rn}
\alias{tsnet_rn}
\title{Construct the recurrence network from a time series.}
\usage{
tsnet_rn(x, radius, embedding.dim, time.lag = 1, do.plot = FALSE, ...)
}
\arguments{
\item{x}{Array. Time series}

\item{radius}{Maximum distance between two phase-space
points to be considered a recurrence.}

\item{embedding.dim}{Integer denoting the dimension in which
we shall embed the time.series. If missing, the embedding
dimensions is estimated using `estimateEmbeddingDim()` from
\pkg{nonlinearTseries}. The constructed igraph network has
the estimated dimension (and other info) as a parameter.
For example: net$embedding_dim}

\item{time.lag}{Integer denoting the number of time steps that
will be use to construct the Takens' vectors.}

\item{do.plot}{Boolean. Show recurrence plot (default = FALSE)}

\item{...}{Other parameters to `rqa()` from \pkg{nonlinearTseries}}
}
\value{
recurrence network
}
\description{
This function constructs the recurrence matrix of the time
series using the function `rqa()` from \pkg{nonlinearTseries}
package.
}
