% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_dist.R
\name{ts_dist}
\alias{ts_dist}
\title{Calculate distances between pairs of time series in a list.}
\usage{
ts_dist(
  ts_list,
  dist_func = tsdist_cor,
  is_symetric = TRUE,
  error_value = NaN,
  warn_error = TRUE,
  num_cores = 1,
  ...
)
}
\arguments{
\item{ts_list}{List of time series (arrays).}

\item{dist_func}{Function to be applied to all combinations
of time series. This function should have at least two parameters
for each time series. Ex: function(ts1, ts2){ cor(ts1, ts2) }}

\item{is_symetric}{Boolean. If the distance function is symmetric.}

\item{error_value}{The value returned if an error occur when calculating a
the distance for a pair of time series.}

\item{warn_error}{Boolean. If TRUE (default), a warning will rise when an
error occur during the calculations.}

\item{num_cores}{Numeric. Number of cores}

\item{...}{Additional parameters for measureFunc}
}
\value{
A distance or similarity matrix M whose position M_{ij}
    corresponds to distance or similarity value between time series
    i and j.
}
\description{
This function calculates the distance between all combinations of
time series in the list and returns a distance matrix. This function
is usually the first try and might work if the number of time series
and their length are not too big.
}
