% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limited_Labels_Compact.R
\name{limitedLabelsCompact}
\alias{limitedLabelsCompact}
\title{Convert a call stack into a list of printable strings}
\usage{
limitedLabelsCompact(value, compact = FALSE, maxwidth = getOption("width") -
  5L)
}
\arguments{
\item{value}{a list of calls ("call.stack") generated by \code{\link{sys.calls}}}

\item{compact}{if TRUE only calls that contain a source code reference (attribute "srcref") are returned
(plus always the first call); if FALSE all calls will be returned.}

\item{maxwidth}{Maximum number of characters per call in the return value (longer strings will be cutted).
Must be between 40 and 1000}
}
\value{
A list of strings (one for each call)
}
\description{
Converts a call stack into a list of printable strings ("labels") with a limited length per call.
                If source code references are available they are also added in the form
                \<file name\>#\<line number\>: executed R expression (call)
}
\details{
R does track source code references only if you set the option "keep.source" to TRUE via
                \code{options(keep.source = TRUE)}. Without this option this function cannot enrich source code references.
                If you use \command{Rscript} to start a non-interactive R script as batch job you
                have to set this option since it is FALSE by default. You can add this option to your
                \link{.Rprofile} file or use a startup R script that sets this option and sources your
                actual R script then.

                This function is base on the undocumented \code{\link{limitedLabels}} function of the base package.
                The source code can be viewed by entering \code{limitedLabels} in the R console.
                The attributes required to add source file names and line numbers to the calls (srcref and srcfile)
                and how they are created internally are explained in this article:
                \url{https://journal.r-project.org/archive/2010-2/RJournal_2010-2_Murdoch.pdf}
}
\examples{
limitedLabelsCompact(sys.calls(), TRUE)
}
\seealso{
\code{\link{sys.calls}}, \code{\link{tryCatchLog}}, \code{\link{get.pretty.call.stack}}
}
