% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffTox.R
\name{efftox_contour_plot}
\alias{efftox_contour_plot}
\title{Plot EffTox utility contours}
\usage{
efftox_contour_plot(fit, use_ggplot = FALSE, prob_eff = fit$prob_eff,
  prob_tox = fit$prob_tox, num_points = 1000, util_vals = seq(-3, 3, by =
  0.2))
}
\arguments{
\item{fit}{An instance of \code{\link{efftox_fit}}.}

\item{use_ggplot}{logical, TRUE to use ggplot2. Defaults to FALSE to use
standard R graphics.}

\item{prob_eff}{vector of numbers between 0 and 1, containing the
efficacy probabilities of extra points to add to the plot as points,
e.g. the posterior mean efficacy probabilities of the doses under
investigation. Paired with prob_tox, thus they should be the same length.
Defaults to the values fitted by the model. Use NULL to supress.}

\item{prob_tox}{vector of numbers between 0 and 1, containing the
toxicity probabilities of extra points to add to the plot as points,
e.g. the posterior mean toxicity probabilities of the doses under
investigation. Paired with prob_eff, thus they should be the same length.
Defaults to the values fitted by the model. Use NULL to supress.}

\item{num_points}{integer for number of points to calculate on each curve.
The default is 1000 and this should be plenty.}

\item{util_vals}{A contour is plotted for each of these utility values.
The default is contours spaced by 0.2 between from -3 and 3,
i.e. \code{seq(-3, 3, by = 0.2)}.}
}
\value{
if \code{use_ggplot = TRUE}, an instance of \code{ggplot}; else no
object is returned. Omit assignment in either case to just view the plot.
}
\description{
Plot EffTox utility contours. The probability of efficacy is
on the x-axis and toxicity on the y-axis. The zero-utility curve is plotted
bolder. The three "hinge points" are plotted as blue triangles. Optional
Prob(Efficacy) vs Prob(Toxicity) points can be added; these are shown as
red numerals, enumerated in the order provided.
}
\examples{
fit <- stan_efftox_demo(outcome_str = '1N 2E 3B')
efftox_contour_plot(fit)
title('EffTox utility contours')
# The same with ggplot2
efftox_contour_plot(fit, use_ggplot = TRUE) +
                    ggplot2::ggtitle('EffTox utility contours')

}
\seealso{
\code{\link{stan_efftox}}
}
