% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffTox.R
\name{efftox_solve_p}
\alias{efftox_solve_p}
\title{Calculate the p-index for EffTox utility contours}
\usage{
efftox_solve_p(eff0, tox1, eff_star, tox_star)
}
\arguments{
\item{eff0}{Efficacy probability required when toxicity is impossible;
a number between 0 and 1}

\item{tox1}{Toxicity probability permitted when efficacy is guaranteed;
a number between 0 and 1}

\item{eff_star}{Efficacy probability of an equi-utility third point}

\item{tox_star}{Toxicity probability of an equi-utility third point}
}
\value{
The p-index
}
\description{
Calculate the p-index for EffTox utility contours so that the neutral utility
contour intersects the following points in the
Prob(Efficacy) - Prob(Toxicity) plane:
(\code{eff0}, 0), (1, \code{tox1}) and (\code{eff_star}, \code{tox_star})
}
\examples{
efftox_solve_p(0.5, 0.65, 0.7, 0.25)

}
\references{
Thall, Herrick, Nguyen, Venier & Norris. 2014, Effective sample
size for computing prior hyperparameters in Bayesian phase I-II dose-finding
}
