% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_betweenness.R
\name{max_betweenness}
\alias{max_betweenness}
\title{Maximum betweenness centrality.}
\usage{
max_betweenness(phy, normalization = "none")
}
\arguments{
\item{phy}{phylo object or ltable}

\item{normalization}{"none" or "tips", if tips is chosen, the obtained
maximum betweenness is normalized by the total amount of node pair
combinations considered, e.g. (n-2)*(n-1), where n is the number of tips.}
}
\value{
Maximum Betweenness
}
\description{
Betweenness centrality associates with each node v, the two
nodes u, w, for which the shortest path between u and w runs through v, if
the tree were re-rooted at node v. Then, we report the node with maximum
betweenness centrality.
}
\references{
Chindelevitch, Leonid, et al. "Network science inspires novel
tree shape statistics." Plos one 16.12 (2021): e0259877.
}
