% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.model_unified}
\alias{predict.model_unified}
\title{Predict}
\usage{
\method{predict}{model_unified}(object, x, ...)
}
\arguments{
\item{object}{Unified model representation of the model created with a (model).unify function. \code{\link{model_unified.object}}}

\item{x}{Observations to predict. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model.}

\item{...}{other parameters}
}
\value{
a vector of predictions.
}
\description{
Predict using unified_model representation.
}
\examples{
\donttest{
library(gbm)
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
data['value_eur'] <- fifa20$target
gbm_model <- gbm::gbm(
  formula = value_eur ~ .,
  data = data,
  distribution = "laplace",
  n.trees = 20,
  interaction.depth = 4,
  n.cores = 1)
  unified <- gbm.unify(gbm_model, data)
  predict(unified, data[2001:2005, ])
  }
}
