% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-methods.R
\name{getNdsSlt}
\alias{getNdsSlt}
\title{Get a node slot for multiple nodes}
\usage{
getNdsSlt(tree, slt_nm, ids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{slt_nm}{slot name}

\item{ids}{vector of node ids}

\item{...}{\code{plyr} arguments}
}
\description{
Returns the value of named slot.
}
\details{
Returned object depends on name, either character, vector or numeric. Parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsSlt(tree, slt_nm='spn', ids=tree['tips'])  # return spans of all tips
}
\seealso{
\code{\link{getNdSlt}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}

