% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_genetree_summary_stat.R
\name{genetree_summary_stat}
\alias{genetree_summary_stat}
\title{Calculate summary statistics for gene trees}
\usage{
genetree_summary_stat(container_tree_gene_tree_obj, container_tree_indx)
}
\arguments{
\item{container_tree_gene_tree_obj}{Locus tree object obtain from `sim_locustree_genetree_mlc`}

\item{container_tree_indx}{Index of locus tree object of interest}
}
\value{
Dataframe with summary statistics for each gene tree
}
\description{
Calculates summary statistics including Colless' statistic, gamma statistic of the locus tree input as an index as part of a list, gamma statistic of gene tree, sackin statistic, cherry statistic, and time to most recent common ancestor
}
\examples{
# first simulate a species tree
mu <- 0.5
lambda <- 1.0
nt <- 6
tr <- sim_sptree_bdp(sbr = lambda, sdr = mu, numbsim = 1, n_tips = nt)
# for a locus tree with 100 genes sampled per locus tree
gentrees <- sim_multispecies_coal(tr[[1]],
                                  ne = 10000,
                                  num_sampled_individuals = 1,
                                  num_genes = 100)

gt_df <- genetree_summary_stat(gentrees, container_tree_indx = 1)
}
