% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cophy.R
\name{draw_cophy}
\alias{draw_cophy}
\title{Internal tree plot function}
\usage{
draw_cophy(
  x,
  y,
  assoc = assoc,
  use_edge_length = use_edge_length,
  length_line = length_line,
  type = type,
  return = return,
  col = col,
  lwd = lwd,
  lty = lty,
  show_tip_label = show_tip_label,
  font = font,
  fsize = fsize,
  gap = gap,
  show_scalebar = show_scalebar,
  scalebar_fsize = scalebar_fsize,
  ...
)
}
\arguments{
\item{x}{Host tree as phylo object}

\item{y}{Symb tree as phylo object}

\item{assoc}{Association matrix as a two column list of strings}

\item{use_edge_length}{Boolean to draw trees with edge length or not}

\item{length_line}{Length of interactions lines}

\item{type}{string "phylogram" or "cladogram"}

\item{return}{Return an object or no (default = FALSE)}

\item{col}{What color to draw links between trees}

\item{lwd}{Width of links between trees}

\item{lty}{Type of line to draw between trees}

\item{show_tip_label}{Boolean for showing labels}

\item{font}{What font to use (bold, italic (default), etc.)}

\item{fsize}{What size font as a character expansion factor (same as cex)}

\item{gap}{Gap between tips and tip names}

\item{show_scalebar}{Boolean for turning on and off the scalebar}

\item{scalebar_fsize}{Font size of scalebar}

\item{...}{Other plotting parameters}
}
\description{
internal plot function from ape::plotCophylo2 under GPL v. 2
}
\references{
Paradis E. & Schliep K. 2019. ape 5.0: an environment for modern
phylogenetics and evolutionary analyses in R. Bioinformatics 35:
526-528.
}
\keyword{Internal}
