% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_node_heights.R
\name{calculate_expected_leaves_locustree}
\alias{calculate_expected_leaves_locustree}
\title{Calculate expected leaves of a locus tree}
\usage{
calculate_expected_leaves_locustree(t, dup_rate, loss_rate, num_species)
}
\arguments{
\item{t}{time to simulate until (the length of the species tree)}

\item{dup_rate}{gene birth rate}

\item{loss_rate}{gene death rate}

\item{num_species}{number of leaves on the species tree}
}
\value{
The expected number of leaves
}
\description{
Calculate expected leaves of a locus tree
}
\details{
Calculates the expected number of leaves for a birth-death
   simulation given a gene birth and death rate, a time, and the number of
   leaves on the species tree that the locus tree is to be simulated upon.
}
\examples{
gene_birth_rate <- 1.0
gene_death_rate <- 0.5
time <- 2
num_species <- 10
calculate_expected_leaves_locustree(time,
                                    gene_birth_rate,
                                    gene_death_rate,
                                    num_species)
}
\references{
Mallo, D., de Oliveira Martins, L., & Posada, D. (2016). SimPhy: phylogenomic
     simulation of gene, locus, and species trees. Systematic biology, 65(2),
      334-344.
}
