% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.tip.treats.R
\name{drop.tip.treats}
\alias{drop.tip.treats}
\alias{keep.tip.treats}
\title{drop.tip.treats}
\usage{
\method{drop.tip}{treats}(phy, tip, ...)
}
\arguments{
\item{phy}{an object of class \code{"treats"}.}

\item{tip}{a vector of mode numeric or character specifying the tips to delete or to keep.}

\item{...}{any additional argument to be passed to \code{\link[ape]{drop.tip.phylo}}.}
}
\value{
This function outputs either a \code{"phylo"} object if no traits where generated or a \code{treats} object that is a list of at least two elements: \code{$tree}, a \code{"phylo"} object and \code{$data}, a \code{"matrix"} of the trait values.
}
\description{
Drop or keep tips from a \code{"treats"} object.
}
\details{
This function allows to remove or keep tips from a \code{"treats"} object the same way as the \code{\link[ape]{drop.tip.phylo}} function.
}
\examples{
## A treats object with one trait and 20 tips
my_treats <- treats(stop.rule = list(max.taxa = 20),
                   traits = make.traits())

## Removing five tips
drop.tip.treats(my_treats, tip = c("t1", "t2", "t3", "t4", "t5"))

## Keeping these five tips
drop.tip.treats(my_treats, tip = c("t1", "t2", "t3", "t4", "t5"))

}
\seealso{
\code{\link{treats}}
}
\author{
Thomas Guillerme
}
