% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{ckd_epi_US}
\alias{ckd_epi_US}
\title{eGFR by CKD-EPI equation (US units)}
\usage{
ckd_epi_US(creat, age, sex, ethnicity, offset = 0)
}
\arguments{
\item{creat}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{age}{numeric vector of age in years (accepts integers or decimals)}

\item{sex}{character vector of sex ("F" for female, "M" for male)}

\item{ethnicity}{character vector of patient ethnicity, one of "black" or "non-black"}

\item{offset}{non-vectorised optional parameter for offset in years}
}
\value{
a numeric vector of eGFR values
}
\description{
A wrapper function for the ckd_epi() vectorised function to calculate estimated glomerular
filtration rate using the CKD-EPI equation, using serum creatinine in mg/dl.
To allow for serial measurements over time, such as
for transplant follow-up data, there is an optional offset = n parameter which increases the age
value used in the equation by n years.
}
\details{
Reference: Levey AS, Stevens LA, Schmid CH, et al. A new equation to estimate glomerular filtration
rate. Ann Intern Med 2009; 150(9):604-612.
}
\examples{
ckd_epi_US(creat = 1.5, age = 64.3, sex = "F", ethnicity = "black")
}
