% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendalls.R
\name{kendall}
\alias{kendall}
\title{Kendall's tau}
\usage{
kendall(x, y = NULL)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector with compatible length to \code{x}.}
}
\value{
The output is a numeric value for the unconditional Kendall's tau.
}
\description{
Computes the Unconditional Kendall's Tau
}
\details{
This function computes the unconditional Kendall's tau (the Kendall rank correlation coefficient) for two variables.
The returned value is equivalent to that from \code{cor} with \code{method = "kendall"}, but \code{kendall} is
implemented in C.
}
\examples{
library(copula)
norm.cop <- normalCopula(iTau(normalCopula(), .5))
set.seed(1)
dat <- rCopula(5000, norm.cop)
system.time(print(kendall(dat)))
system.time(print(cor(dat, method = "kendall")))
}
\references{
Kendall, M. G. (1938), A new measure of rank correlation, \emph{Biometrika}, 81--93.
}
\seealso{
\code{\link{cor}}
}
