% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{TrajSmoothSG}
\alias{TrajSmoothSG}
\title{Smooth a trajectory using a Savitzky-Golay filter}
\usage{
TrajSmoothSG(trj, p = 3, n = p + 3 - p\%\%2, ...)
}
\arguments{
\item{trj}{The trajectory to be smoothed.}

\item{p}{polynomial order (passed to \code{\link[signal]{sgolayfilt}}).}

\item{n}{Filter length (or window size), must be an odd number.  Passed to
\code{\link[signal]{sgolayfilt}}.}

\item{...}{Additional arguments are passed to \code{\link[signal]{sgolayfilt}}.}
}
\value{
A new trajectory which is a smoothed version of the input trajectory.
}
\description{
Smooths a trajectory using a Savitzky-Golay smoothing filter.
}
\examples{
set.seed(3)
trj <- TrajGenerate(500, random = TRUE, angularErrorSd = .25)
smoothed <- TrajSmoothSG(trj, 3, 31)
plot(trj)
plot(smoothed, col = "red", add = TRUE)

}
\seealso{
\code{\link[signal]{sgolayfilt}}
}
