% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajhrmsm_ipw.R
\name{trajhrmsm_ipw}
\alias{trajhrmsm_ipw}
\title{History Restricted MSM and Latent Class of Growth Analysis estimated with IPW.}
\usage{
trajhrmsm_ipw(
  degree_traj = c("linear", "quadratic", "cubic"),
  numerator = c("stabilized", "unstabilized"),
  identifier,
  baseline,
  covariates,
  treatment,
  outcome,
  var_cov,
  include_censor = FALSE,
  ntimes_interval,
  total_followup,
  time,
  time_values,
  family = "poisson",
  censor = censor,
  number_traj,
  obsdata,
  weights = NULL,
  treshold = 0.999
)
}
\arguments{
\item{degree_traj}{To specify the polynomial degree for modelling the time-varying treatment.}

\item{numerator}{To choose between stabilized and unstabilized weights.}

\item{identifier}{Name of the column of the unique identifier.}

\item{baseline}{Names of the baseline covariates.}

\item{covariates}{Names of the time-varying covariates (should be a list).}

\item{treatment}{Name of the time-varying treatment.}

\item{outcome}{Name of the outcome variable.}

\item{var_cov}{Names of the time-varying covariates.}

\item{include_censor}{Logical, if TRUE, includes censoring.}

\item{ntimes_interval}{Length of a time-interval (s).}

\item{total_followup}{Total length of follow-up.}

\item{time}{Name of the time variable.}

\item{time_values}{Values of the time variable.}

\item{family}{specification of the error distribution and link function to be used in the model.}

\item{censor}{Name of the censoring variable.}

\item{number_traj}{Number of trajectory groups.}

\item{obsdata}{Data in a long format.}

\item{weights}{A vector of estimated weights. If NULL, the weights are computed by the function.}

\item{treshold}{For weight truncation.}
}
\value{
Provides a matrix of estimates for LCGA-HRMSM, obtained using IPW.
}
\description{
Estimate parameters of LCGA-HRMSM using IPW.
}
\examples{
\donttest{
obsdata_long = gendata(n = 1000, format = "long", total_followup = 8,
timedep_outcome = TRUE,  seed = 945)
baseline_var <- c("age","sex")
years <- 2011:2018
variables <- c("hyper", "bmi")
covariates <- lapply(years, function(year) {
paste0(variables, year)})
treatment_var <- paste0("statins", 2011:2018)
var_cov <- c("statins","hyper", "bmi","y")
reshrmsm_ipw <- trajhrmsm_ipw(degree_traj = "linear", numerator = "stabilized",
identifier = "id", baseline = baseline_var,
covariates = covariates, treatment = treatment_var,
outcome = "y", var_cov= var_cov,include_censor = FALSE,
 ntimes_interval = 6,total_followup = 8, time = "time", time_values = 2011:2018,
family = "poisson", number_traj = 3, obsdata = obsdata_long, treshold = 0.999)
reshrmsm_ipw$res_trajhrmsm_ipw
}
}
\author{
Awa Diop, Denis Talbot
}
