% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trajClusters.R
\name{plot.trajClusters}
\alias{plot.trajClusters}
\alias{scatterplots}
\alias{critplot}
\title{Plots \code{trajClusters} objects}
\usage{
\method{plot}{trajClusters}(x, sample.size = 5, ask = TRUE, which.plots = NULL, spline = FALSE, ...)

scatterplots(x, ask = TRUE, ...)

critplot(x, ...)
}
\arguments{
\item{x}{object of class \code{trajClusters} as returned by
\code{Step3Cluster}.}

\item{sample.size}{the number of random trajectories to be randomly sampled
from each cluster. Defaults to \code{5}.}

\item{ask}{logical. If \code{TRUE}, the user is asked before each plot. Defaults to
\code{TRUE}.}

\item{which.plots}{either \code{NULL} or a vector of integers. If \code{NULL}, every
available plot is displayed. If a vector is supplied, only the corresponding
plots will be displayed.}

\item{spline}{logical. If \code{TRUE}, each trajectory will be smoothed using
smoothing splines and the median and mean trajectories will be plotted from
the smoothed trajectories. Defaults to \code{FALSE}}

\item{...}{other parameters to be passed through to plotting functions.}
}
\description{
Plots the
cluster-specific median and mean trajectories and a random sample of
trajectories from each cluster.
}
\examples{
\dontrun{
data("trajdata")
trajdata.noGrp <- trajdata[, -which(colnames(trajdata) == "Group")] #remove the Group column

m = Step1Measures(trajdata.noGrp, ID = TRUE)
s = Step2Selection(m)
c3 = Step3Clusters(s, nclusters = 3)

plot(c3)

#The pointwise mean trajectories correspond to the third and fourth displayed plots.

c4 = Step3Clusters(s, nclusters = 4)

plot(c4, which.plots = 3:4)

}


}
\seealso{
\code{\link[traj]{Step3Clusters}}
}
