% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fe_native.R
\name{fe_native}
\alias{fe_native}
\title{Check species status (native, exotic, ...) for one species from Flora Europaea webpage}
\usage{
fe_native(sp, ...)
}
\arguments{
\item{sp}{character; a vector of length one with a single scientific species names in
the form of \code{c("Genus species")}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A list of vectors containing the countries where the species is native, exotic, ...
}
\description{
This function check the status (native or exotic) of a species in each of
the eu countries.

For that end, it checks Flora Europaea (http://rbg-web2.rbge.org.uk/FE/fe.html) and scrapes
the data from there.

Note that the webpage contains more information.

As expected, the function is as good as the database is. I think for native species
is robust but new exotic species are not added as to my knowledge the database is
not updated anymore. The database is not able to recognize species synonyms.

See \url{http://rbg-web2.rbge.org.uk/FE/data/countries} for explanation of the
database codes.
}
\examples{
\dontrun{
sp <- c("Lavandula stoechas", "Carpobrotus edulis", "Rhododendron ponticum",
       "Alkanna lutea", "Anchusa arvensis")
fe_native(sp[1])
sapply(sp, fe_native, simplify = FALSE)
}
}
\author{
Ignasi Bartomeus \email{nacho.bartomeus@gmail.com}
}

