% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_summary.R
\name{plot.trackeRdataSummary}
\alias{plot.trackeRdataSummary}
\title{Plot an object of class \code{\link{trackeRdataSummary}}.}
\usage{
\method{plot}{trackeRdataSummary}(x, date = TRUE, what = NULL, group = NULL, trend = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{trackeRdataSummary}.}

\item{date}{Should the date or the session number be used on the abscissa?}

\item{what}{Name of variables which should be plotted. Default is all. A vector with at least one of \code{"distance"}, \code{"duration"}, \code{"avgSpeed"}, \code{"avgPace"}, \code{"avgCadenceRunning"}, \code{"avgCadenceCycling"}, \code{"avgAltitude"}, \code{"avgPower"}, \code{"avgHeartRate"}, \code{"avgTemperature"}, \code{"wrRatio"}, \code{"total_elevation_gain"}, and \code{NULL}, in which case all variables are plotted.}

\item{group}{Which group of variables should be plotted? This can either be
\code{total} or \code{moving}. Default is both.}

\item{trend}{Should a smooth trend be plotted?}

\item{...}{Currently not used.}
}
\description{
Plot an object of class \code{\link{trackeRdataSummary}}.
}
\examples{
\dontrun{
data('runs', package = 'trackeR')
runSummary <- summary(runs)
plot(runSummary)
plot(runSummary, date = FALSE, group = 'total',
    what = c('distance', 'duration', 'avgSpeed'))
}
}
\seealso{
\code{\link{summary.trackeRdata}}
}
