% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeR.R
\name{timeline}
\alias{timeline}
\title{Generic function for visualising the sessions on a time versus date plot.}
\usage{
timeline(object, lims, ...)
}
\arguments{
\item{object}{An object of class trackeRdata or trackeRdataSummary}

\item{lims}{An optional vector of two times in HH:MM format. Default is NULL.
If supplied, the times are used to define the limits of the time axis.}

\item{...}{Arguments passed to \code{\link{summary.trackeRdata}}}
}
\description{
Generic function for visualising the sessions on a time versus date plot.
}
\examples{
\dontrun{
data("runs", package = "trackeR")
## timeline plot applied on the trackeRdata object directly and with
## inferred limits for the time axis
timeline(runs)

## the same timeline plot applied on the trackeRdataSummary object
runSummary <- summary(runs)
timeline(runSummary, lims = c("00:01", "23:59"))
}
}
