% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapSite.R
\name{mapSite}
\alias{mapSite}
\title{Make simple maps of aggregation and important sites}
\usage{
mapSite(Site, colony = NULL, show = TRUE)
}
\arguments{
\item{Site}{Simple feature MULTIPOLYGON object or SpatialPixelsDataFrame.
Must be output of \code{\link{findSite}} function).}

\item{colony}{data.frame. Optional. Must contain columns named 'Latitude' and
'Longitude', with coordinate locations to display reference point of, for
example, a breeding or tagging site.}

\item{show}{logical. show plot, or just save it. Note, saving plot only works
for Simple Features input. Default is TRUE.}
}
\value{
Returns a figure of either single map with all core ranges displayed
together, or a series of facetted maps, each of which shows a utilization
distribution corresponding to a level of ID in \emph{KDE}.
}
\description{
\code{mapSite} uses output from \code{findSite} to create maps illustrating
density of animals in space, and borders of potentially important areas for
the population.
}
\details{
If the input is simple features polygons (i.e. \code{polyOut = TRUE} in
\code{findSite}), areas which meet threshold of importance are displayed
(in red) on top of of the estimated density of animals in space. Black
borders are political and coastline borders.If there are no red borders areas
 displayed on the map, then either the species doesn't aggregatee enough to
 meet the threshold, or the tracked sample aren't representative enough to
 identify significant aggregations.

If input is SpatialPixelsDataFrame (i.e. \code{polyOut = FALSE} in
\code{findSite}), a simple density surface map is plotted.
}
\examples{

tracks_raw <- track2KBA::boobies

## format data
tracks_formatted <- formatFields(
  dataGroup = tracks_raw,
  fieldID   = "track_id",
  fieldLat  ="latitude",
  fieldLon  ="longitude",
  fieldDate ="date_gmt",
  fieldTime ="time_gmt"
)

\dontshow{
library(dplyr)
tracks_formatted <- dplyr::filter(
tracks_formatted, ID \%in\% c("69324", "69302", "69343", "69304")
) \%>\%  dplyr::filter(row_number() \%\% 10 == 1)
}

## project dataset
tracks_prj <- projectTracks(
  tracks_formatted,
  projType = "azim",
  custom = "TRUE"
)

## get utilization distributions
KDE <- estSpaceUse(tracks_prj, scale = 20, levelUD = 50)

\dontrun{
## estimate represenativeness of sample
result <- repAssess(tracks_prj, KDE, levelUD = 50, iteration = 50)
}

\dontshow{
result <- data.frame(out = 90)
}
## identify potential sites
pot_site <- findSite(KDE, represent = result$out, levelUD = 50)
## Map it 
mapSite(pot_site)

}
\seealso{
\code{\link{estSpaceUse}}
}
