% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_trees_file.R
\name{is_trees_file}
\alias{is_trees_file}
\title{Measure if a file a valid BEAST2 \code{.trees} file}
\usage{
is_trees_file(trees_filename, verbose = FALSE)
}
\arguments{
\item{trees_filename}{name of a BEAST2 posterior \code{.trees} file,
as can be read using \link{parse_beast_trees}}

\item{verbose}{set to TRUE for more output}
}
\value{
TRUE if \code{trees_filename} is a valid \code{.trees} file
}
\description{
Measure if a file a valid BEAST2 \code{.trees} file
}
\examples{
# TRUE
is_trees_file(get_tracerer_path("beast2_example_output.trees"))
is_trees_file(get_tracerer_path("unplottable_anthus_aco.trees"))
is_trees_file(get_tracerer_path("anthus_2_4_a.trees"))
is_trees_file(get_tracerer_path("anthus_2_4_b.trees"))
# FALSE
is_trees_file(get_tracerer_path("mcbette_issue_8.trees"))
}
\seealso{
Most of the work is done by \link[ape]{read.nexus}
}
\author{
Richèl J.C. Bilderbeek
}
