% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast_output_files.R
\name{parse_beast_output_files}
\alias{parse_beast_output_files}
\title{Parse all BEAST2 output files}
\usage{
parse_beast_output_files(log_filename, trees_filenames, state_filename)
}
\arguments{
\item{log_filename}{name of the BEAST2 .log file}

\item{trees_filenames}{name(s) of the BEAST2 .trees file(s) created.
BEAST2 will create one .trees file per alignment}

\item{state_filename}{name of the BEAST2 .xml.state file created}
}
\value{
a list with the following elements:\cr
  \itemize{
    item{\code{estimates}: parameter estimates}
    item{
      \code{[alignment_id]_trees}: the phylogenies in the
      BEAST2 posterior. \code{[alignment_id]} is the ID
      of the alignment.
    }
    item{\code{operators}: the BEAST2 MCMC operator
      acceptances
    }
  }
}
\description{
Parse all BEAST2 output files
}
\examples{
  trees_filenames <- get_tracerer_path("beast2_example_output.trees")
  log_filename <- get_tracerer_path("beast2_example_output.log")
  state_filename <- get_tracerer_path("beast2_example_output.xml.state")
  out <- parse_beast_output_files(
    log_filename = log_filename,
    trees_filenames = trees_filenames,
    state_filename = state_filename
  )
  testit::assert("estimates" \%in\% names(out))
  testit::assert("beast2_example_output_trees" \%in\% names(out))
  testit::assert("operators" \%in\% names(out))
}
\seealso{
Use \code{\link{remove_burn_ins}} to remove the burn-in from
  \code{out$estimates}
}
\author{
Richèl J.C. Bilderbeek
}
