% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvasSize.R
\name{canvasSize}
\alias{canvasSize}
\title{Get predefined canvas sizes}
\usage{
canvasSize(canvas, scale = 1, simplify = TRUE)
}
\arguments{
\item{canvas}{Can either be a character with one of the values
\itemize{
\item{"standard"} A powerpoint standard size, and
two can be shown side by side - 7.2 by 5.4 in (WxH).
\item{"wide"} For a single wide plot on a powerpoint slide - 9.6 by 5.4 in
\item{"A4"} A full A4 page - 5.4 by 7.2 in
\item{"square"} As reads - 5.4 by 5.4 in
\item{"wide-screen"} For full screen display - 18.6 by 9 in
}
or it can be a list with elements
width and height with single values (unit is inches). Example:
canvas=list(height=5,width=9).}

\item{scale}{A scale to apply to both directions of the canvas
size. This can be useful in combination with the pre-defined
canvas sizes.}

\item{simplify}{If only one canvas returned and simplify=TRUE, the
result will not be wrapped in a list. For programming, you
most likely want simplify=FALSE to be sure to always get the
same format back.}
}
\value{
A list with numerical elements width and height as used by
ggwrite.
}
\description{
Get predefined canvas sizes
}
\seealso{
Other Plotting: 
\code{\link{ggstamp}()},
\code{\link{ggwater}()},
\code{\link{ggwrite}()}
}
\concept{Plotting}
