% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxpiR-package.R
\name{toxpiR-datasets}
\alias{toxpiR-datasets}
\alias{txp_example_input}
\alias{txp_example_model}
\title{toxpiR data objects}
\source{
\url{https://github.com/ToxPi/ToxPi-example-files}
}
\usage{
data(txp_example_input, package = "toxpiR")

data(txp_example_model, package = "toxpiR")
}
\description{
Objects included in the toxpiR package, loaded with
\link[utils:data]{utils::data}
}
\section{txp_example_input}{


Small example input data to be used with \link{txpCalculateScores} in creating
\link{TxpResult} objects. A \link[base:data.frame]{base::data.frame} with 10 rows and 9 variables
\describe{
\item{name}{Observation names}
\item{metric#}{Input data for ToxPi models}
}
}

\section{txp_example_model}{


Example \link{TxpModel} object intended for \code{txp_example_data}; model with 4
slices.
}

\examples{
data(txp_example_input, package = "toxpiR")
data(txp_example_model, package = "toxpiR")
txp_example_input
txp_example_model

## Code to create txp_example_model
tf1 <- TxpTransFuncList(linear = function(x) x)
sl <- TxpSliceList(s1 = TxpSlice(sprintf("metric\%d", 1:2)),
                   s2 = TxpSlice("metric3"),
                   s3 = TxpSlice(sprintf("metric\%d", 4:7),
                                 tf1[rep("linear", 4)]),
                   s4 = TxpSlice("metric8", tf1))
tf2 <- TxpTransFuncList(NULL, linear = function(x) x, NULL, NULL)
TxpModel(txpSlices = sl, txpWeights = c(2, 1, 3, 2), txpTransFuncs = tf2)

}
