% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpResult.R
\docType{class}
\name{TxpResult-class}
\alias{TxpResult-class}
\alias{TxpResult}
\alias{txpScores,TxpResult-method}
\alias{txpSliceScores,TxpResult-method}
\alias{txpRanks,TxpResult-method}
\alias{txpModel,TxpResult-method}
\alias{txpIDs,TxpResult-method}
\alias{txpIDs<-,TxpResult-method}
\alias{txpWeights,TxpResult-method}
\alias{txpSlices,TxpResult-method}
\alias{txpTransFuncs,TxpResult-method}
\alias{txpValueNames,TxpResult-method}
\alias{[,TxpResult,logical,missing-method}
\alias{[,TxpResult,integer,missing-method}
\alias{[,TxpResult,numeric,missing-method}
\alias{[,TxpResult,character,missing-method}
\alias{length,TxpResult-method}
\alias{sort,TxpResult-method}
\alias{names,TxpResult-method}
\alias{names<-,TxpResult-method}
\alias{as.data.frame,TxpResult-method}
\title{ToxPi Result}
\usage{
\S4method{txpScores}{TxpResult}(x)

\S4method{txpSliceScores}{TxpResult}(x, adjusted = TRUE)

\S4method{txpRanks}{TxpResult}(x)

\S4method{txpModel}{TxpResult}(x)

\S4method{txpIDs}{TxpResult}(x)

\S4method{txpIDs}{TxpResult}(x) <- value

\S4method{txpWeights}{TxpResult}(x, adjusted = FALSE)

\S4method{txpSlices}{TxpResult}(x)

\S4method{txpTransFuncs}{TxpResult}(x, level, simplify = FALSE)

\S4method{txpValueNames}{TxpResult}(x, simplify = FALSE)

\S4method{[}{TxpResult,logical,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{TxpResult,integer,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{TxpResult,numeric,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{TxpResult,character,missing}(x, i, j, ..., drop = FALSE)

\S4method{length}{TxpResult}(x)

\S4method{sort}{TxpResult}(x, decreasing = TRUE, na.last = TRUE, ...)

\S4method{names}{TxpResult}(x)

\S4method{names}{TxpResult}(x) <- value

\S4method{as.data.frame}{TxpResult}(
  x,
  row.names = NULL,
  optional = FALSE,
  ...,
  id.name = "id",
  score.name = "score",
  rank.name = "rank",
  adjusted = FALSE
)
}
\arguments{
\item{x}{\link{TxpResult} object}

\item{adjusted}{Logical scalar, when \code{TRUE} the weights are adjusted to sum
to 1 or the slice scores are scaled to their respective weight}

\item{value}{Replacement value}

\item{level}{\code{c('model', 'slices')}; indicates whether to retrieve
\code{txpTransFuncs} slot from the model or underlying slices}

\item{simplify}{Logical scalar, flatten \code{txpValueNames} or \code{txpTransFunc}
slots when retrieving slice-level information}

\item{i}{Subsetting index}

\item{j, drop, optional}{Not currently implemented}

\item{...}{Passed to \link[base:data.frame]{base::data.frame} in \code{as.data.frame} or \link[base:sort]{base::sort}
in \code{sort}}

\item{decreasing, na.last}{Passed to \link[base:sort]{base::sort}}

\item{row.names}{Passed to \link[base:data.frame]{base::data.frame}}

\item{id.name, score.name, rank.name}{Character scalar; when coercing to
\link[base:data.frame]{base::data.frame}, the name for the \code{txpIDs}, \code{txpScores}, and \code{txpRanks}
columns, respectively}
}
\description{
S4 class to store ToxPi results
}
\section{Functions}{
\itemize{
\item \code{txpScores,TxpResult-method}: Return \code{txpScores} slot

\item \code{txpSliceScores,TxpResult-method}: Return \code{txpSliceScores} slot; default
\code{adjusted = TRUE}, i.e. return slice scores adjusted for weight

\item \code{txpRanks,TxpResult-method}: Return \code{txpRanks} slot

\item \code{txpModel,TxpResult-method}: Return \code{txpModel} slot

\item \code{txpIDs,TxpResult-method}: Return \code{txpIDs} slot

\item \code{txpWeights,TxpResult-method}: Return \code{txpWeights} slot from model -- shortcut
for \code{txpWeights(txpModel(x))}; default \code{adjusted = FALSE}, i.e. return
unadjusted weights

\item \code{txpSlices,TxpResult-method}: Return \code{txpSlices} slot from model -- shortcut
for \code{txpSlices(txpModel(x))}

\item \code{txpTransFuncs,TxpResult-method}: Return \code{txpTransFuncs} slot from model --
shortcut for \code{txpTransFuncs(txpModel(x))}

\item \code{txpValueNames,TxpResult-method}: Return \code{txpValueNames} slot from slices --
shortcut for \code{txpValueNames(txpSlices(txpModel(x)))}

\item \code{length,TxpResult-method}: Return the number of observations; shortcut for
\code{length(txpScores(x))}

\item \code{sort,TxpResult-method}: Sort the ``TxpResult` object by their ranks

\item \code{names,TxpResult-method}: Returns IDs; equal to \code{txpIDs(x)}

\item \code{as.data.frame,TxpResult-method}: Coerce TxpResult to \link[base:data.frame]{base::data.frame} object
with IDs, scores, ranks, and slice scores
}}

\section{Slots}{

\describe{
\item{\code{txpScores}}{\verb{vector(<numeric>)} of model scores}

\item{\code{txpSliceScores}}{\verb{matrix(<numeric>)}, sample by slice \code{matrix} with
individual slice scores}

\item{\code{txpRanks}}{\verb{vector(<numeric>)} with rank of scores}

\item{\code{txpModel}}{\link{TxpModel} object}

\item{\code{txpIDs}}{\verb{vector(<character>)} of observation IDs}
}}

\examples{
## Load example dataset & model; see ?TxpModel for building model objects
data(txp_example_input, package = "toxpiR")
data(txp_example_model, package = "toxpiR")

## Calculate scores for single model; returns TxpResult object
res <- txpCalculateScores(model = txp_example_model, 
                          input = txp_example_input, 
                          id.var = "name")

## Accessors
txpScores(res)

txpSliceScores(res) ## adjusted for weight, by default
apply(txpSliceScores(res), 2, max, na.rm = TRUE)

txpSliceScores(res, adjusted = FALSE) ## each score should have maximum of 1
apply(txpSliceScores(res, adjusted = FALSE), 2, max, na.rm = TRUE)

txpRanks(res)

txpModel(res)
identical(txpModel(res), txp_example_model)

txpIDs(res)
names(res) ## identical to txpIDs(res)
identical(txpIDs(res), names(res))

# Can access TxpModel slots directly
txpWeights(res)
txpWeights(res, adjusted = TRUE)
txpSlices(res)
# When retrieving transform functions, must specify level because both 
# models and slices have transform functions
txpTransFuncs(res, level = "model")

# Can access TxpSliceList slots directly
txpValueNames(res)
txpValueNames(res, simplify = TRUE)
txpTransFuncs(res, level = "slices")
txpTransFuncs(res, level = "slices", simplify = TRUE)

## Subsetting
res[1]
res[c("chem01", "chem09")]
res[grepl("4|6", txpIDs(res))]
\dontrun{
res[c(TRUE, FALSE)] ## gets recycled with warning
}

## length -- returns number of observations
length(res)
length(res[1:5])

## sort
names(res)
names(sort(res))

txpScores(res)
txpScores(sort(res))
txpScores(sort(res, decreasing = FALSE))

## as.data.frame
as.data.frame(res)
as.data.frame(res, id.name = "nm", score.name = "scr", rank.name = "rnk")
}
\seealso{
\link{txpCalculateScores}, \link{plot}, \link{TxpResultList}
}
