% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_endPoint_info.R
\name{clean_endPoint_info}
\alias{clean_endPoint_info}
\title{clean_endPoint_info}
\usage{
clean_endPoint_info(end_point_info)
}
\arguments{
\item{end_point_info}{Data frame Endpoint information from ToxCast.}
}
\value{
The returned data frame is based on end_point_info, but with some endPoints
filtered out and some additional categories in intended_target_family and
intended_target_family_sub. The names in intended_target_family
are revised to look more appealing in graphs and tables.
}
\description{
Define a subset of the ToxCast database for relevance to toxEval analyses. 
Subsetting is done based upon methods defined by 
\href{https://pubs.acs.org/doi/10.1021/acs.est.7b01613}{Blackwell et al., 2017}. 
Specifically, this function removes endPoints that are ATG sources with 
signal loss, and NVS with signal gain (basically: some assay/signal combinations 
are removed because they target non-specific endpoints). Also, this function adds additional 
categories to intended_target_family and intended_target_family_sub as 
described in the paper linked above.
}
\examples{
end_point_info <- end_point_info
cleaned_ep <- clean_endPoint_info(end_point_info)
}
