% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-groupxy.r
\name{display_groupxy}
\alias{display_groupxy}
\alias{animate_groupxy}
\title{Display 2D tour projections displayed separately by groups}
\usage{
display_groupxy(
  centr = TRUE,
  axes = "center",
  half_range = NULL,
  col = "black",
  pch = 20,
  cex = 1,
  edges = NULL,
  edges.col = "black",
  edges.width = 1,
  group_by = NULL,
  plot_xgp = TRUE,
  palette = "Zissou 1",
  ...
)

animate_groupxy(data, tour_path = grand_tour(), ...)
}
\arguments{
\item{centr}{if TRUE, centers projected data to (0,0).  This pins the
center of data cloud and make it easier to focus on the changing shape
rather than position.}

\item{axes}{position of the axes: center, bottomleft or off}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{col}{color to use for points, can be a vector or hexcolors or a factor.  Defaults to "black".}

\item{pch}{shape of the point to be plotted.  Defaults to 20.}

\item{cex}{size of the point to be plotted.  Defaults to 1.}

\item{edges}{A two column integer matrix giving indices of ends of lines.}

\item{edges.col}{colour of edges to be plotted, Defaults to "black"}

\item{edges.width}{line width for edges, default 1}

\item{group_by}{variable to group by. Must have less than 25 unique values.}

\item{plot_xgp}{if TRUE, plots points from other groups in light grey}

\item{palette}{name of color palette for point colour, used by \code{\link{hcl.colors}}, default "Zissou 1"}

\item{...}{other arguments passed on to \code{\link{animate}} and
\code{\link{display_groupxy}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}
}
\description{
This function is designed to allow comparisons across multiple groups,
 especially for examining things like two (or more) different models
 on the same data. The primary display is a scatterplot, with lines or
 contours overlaid.
}
\examples{
animate_groupxy(flea[, 1:6], col = flea$species,
  pch = flea$species, group_by = flea$species)
animate_groupxy(flea[, 1:6], col = flea$species,
  pch = flea$species, group_by = flea$species,
  plot_xgp = FALSE)
}
