% Generated by roxygen2 (4.0.0): do not edit by hand
\docType{data}
\name{Rat CNS}
\alias{Rat CNS}
\alias{ratcns}
\title{Rat CNS Gene Expression}
\format{A 112 x 11 numeric array}
\description{
Columns:
}
\details{
e11  e13  e15  e18  e21   p0   p7  p14    a class1 class2
\itemize{
  \item e11, an ebryonic timepoint from the original data with the number
     corresponding to the day
  \item e13, an ebryonic timepoint from the original data with the number
     corresponding to the day
  \item e15, an ebryonic timepoint from the original data with the number
     corresponding to the day
  \item e18, an ebryonic timepoint from the original data with the number
     corresponding to the day
  \item e21, an ebryonic timepoint from the original data with the number
    corresponding to the day
  \item p0, a postnatal timpoint from the original data with the number
    corresponding to the day
  \item p7, a postnatal timpoint from the original data with the number
    corresponding to the day
  \item p14, a postnatal timpoint from the original data with the number
    corresponding to the day
  \item a, a postnatal timpoint from the original data. It is equivalent to
    p90.
  \item class1, is the high-level class: its range is 1:4
  \item class2, breaks down the high-level classes, so its range is 1:14
}

Rows: Each case is a gene (or gene family?) And each cell is the gene
expression level for that gene at time t, averaging a few measured values
and normalizing using the maximum expression value for that gene.

Reference (available on the web at pnas.org): Large-scale temporal gene
expression mapping of central nervous system development by X. Wen, S.
Fuhrman, G. S. Michaels, D. B. Carr, S. Smith, J. L. Barker, R. Somogyi in
the Proceedings of the National Academy of Science, Vol 95, pp. 334-339,
January 1998
}
\examples{
head(ratcns)
animate_xy(ratcns[,1:8],col=ratcns[,10])
}
\references{
http://www.pnas.org
}
\keyword{datasets}

