% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tosr_load.R
\name{tosr_load}
\alias{tosr_load}
\title{Load Web of Science and Scopus files}
\usage{
tosr_load(...)
}
\arguments{
\item{...}{Web of Science or Scopus files}
}
\value{
List with the following fields: 'df','g','original_df' and 'extensions'.
'df': bibliometrix dataframe.
'g' : Graph from the cited references.
'nodes': dataframe with the nodes atributes of the graph,
'original_df': dataframe from the original data, and
'extensions' : Type of files (.bib or .txt) loaded.
}
\description{
Loads files from Web of Science (txt) and from Scopus (bib) to create a citation graph
}
\examples{
\dontrun{
my_tosr_load <- tosr_load("co-citation_209.txt",
                          "co-citation_380.bib")
}
}
\author{
Sebastian Robledo
}
