% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_lowpass_biquad}
\alias{functional_lowpass_biquad}
\title{Low-pass Biquad Filter (functional)}
\usage{
functional_lowpass_biquad(waveform, sample_rate, cutoff_freq, Q = 0.707)
}
\arguments{
\item{waveform}{(torch.Tensor): audio waveform of dimension of \verb{(..., time)}}

\item{sample_rate}{(int): sampling rate of the waveform, e.g. 44100 (Hz)}

\item{cutoff_freq}{(float): filter cutoff frequency}

\item{Q}{(float, optional): \url{https://en.wikipedia.org/wiki/Q_factor} (Default: \code{0.707})}
}
\value{
\code{tensor}: Waveform of dimension of \verb{(..., time)}
}
\description{
Design biquad lowpass filter and perform filtering.  Similar to SoX implementation.
}
