% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_cholesky_ex}
\alias{linalg_cholesky_ex}
\title{Computes the Cholesky decomposition of a complex Hermitian or real
symmetric positive-definite matrix.}
\usage{
linalg_cholesky_ex(A, check_errors = FALSE)
}
\arguments{
\item{A}{(Tensor): the Hermitian \verb{n \\times n} matrix or the batch of such matrices of size
\verb{(*, n, n)} where \code{*} is one or more batch dimensions.}

\item{check_errors}{(bool, optional): controls whether to check the content of \code{infos}. Default: \code{FALSE}.}
}
\description{
This function skips the (slow) error checking and error message construction
of \code{\link[=linalg_cholesky]{linalg_cholesky()}}, instead directly returning the LAPACK
error codes as part of a named tuple \verb{(L, info)}. This makes this function
a faster way to check if a matrix is positive-definite, and it provides an
opportunity to handle decomposition errors more gracefully or performantly
than \code{\link[=linalg_cholesky]{linalg_cholesky()}} does.
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
If \code{A} is not a Hermitian positive-definite matrix, or if it's a batch of matrices
and one or more of them is not a Hermitian positive-definite matrix,
then \code{info} stores a positive integer for the corresponding matrix.
The positive integer indicates the order of the leading minor that is not positive-definite,
and the decomposition could not be completed.
\code{info} filled with zeros indicates that the decomposition was successful.
If \code{check_errors=TRUE} and \code{info} contains positive integers, then a RuntimeError is thrown.
}
\note{
If \code{A} is on a CUDA device, this function may synchronize that device with the CPU.

This function is "experimental" and it may change in a future PyTorch release.
}
\examples{
if (torch_is_installed()) {
A <- torch_randn(2, 2)
out <- linalg_cholesky_ex(A)
out
}
}
\seealso{
\code{\link[=linalg_cholesky]{linalg_cholesky()}} is a NumPy compatible variant that always checks for errors.

Other linalg: 
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
