% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R, R/wrapers.R
\name{torch_fft_fftfreq}
\alias{torch_fft_fftfreq}
\title{fftfreq}
\usage{
torch_fft_fftfreq(
  n,
  d = 1,
  dtype = torch_get_default_dtype(),
  layout = torch_strided(),
  device = NULL,
  requires_grad = FALSE
)
}
\arguments{
\item{n}{(integer) – the FFT length}

\item{d}{(float, optional) – the sampling length scale. The spacing between individual
samples of the FFT input. The default assumes unit spacing, dividing that result by the
actual spacing gives the result in physical frequency units.}

\item{dtype}{(default: \code{\link[=torch_get_default_dtype]{torch_get_default_dtype()}}) the desired data type of returned tensor.}

\item{layout}{(default: \code{\link[=torch_strided]{torch_strided()}}) the desired layout of returned tensor.}

\item{device}{(default: \code{NULL}) the desired device of returned tensor.  Default:
If \code{NULL}, uses the current device for the default tensor type.}

\item{requires_grad}{(default: \code{FALSE})  If autograd should record operations on the returned tensor.}
}
\description{
Computes the discrete Fourier Transform sample frequencies for a signal of size \code{n}.
}
\note{
By convention, \code{\link[=torch_fft_fft]{torch_fft_fft()}} returns positive frequency terms first, followed by the negative
frequencies in reverse order, so that \code{f[-i]} for all \verb{0 < i <= n/2}
gives the negative frequency terms. For an FFT of length \code{n} and with inputs spaced
in length unit \code{d}, the frequencies are:
\verb{f = [0, 1, ..., (n - 1) // 2, -(n // 2), ..., -1] / (d * n)}

For even lengths, the Nyquist frequency at \code{f[n/2]} can be thought of as either negative
or positive. \code{fftfreq()} follows NumPy’s convention of taking it to be negative.
}
\examples{
if (torch_is_installed()) {
torch_fft_fftfreq(5) # Nyquist frequency at f[3] is positive
torch_fft_fftfreq(4) # Nyquist frequency at f[3] is given as negative

}
}
