% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-options.R
\name{cal_month_options}
\alias{cal_month_options}
\title{Calendar Month Options}
\usage{
cal_month_options(
  cal,
  startDayOfWeek = NULL,
  daynames = NULL,
  narrowWeekend = NULL,
  visibleWeeksCount = NULL,
  isAlways6Week = NULL,
  workweek = NULL,
  visibleScheduleCount = NULL,
  moreLayerSize = NULL,
  grid = NULL,
  scheduleFilter = NULL
)
}
\arguments{
\item{cal}{A \code{\link[=calendar]{calendar()}} object.}

\item{startDayOfWeek}{Numeric. The start day of week.}

\item{daynames}{Vector. The day names in monthly. Default values are 'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'}

\item{narrowWeekend}{Logical. Make weekend column narrow(1/2 width).}

\item{visibleWeeksCount}{Numeric. The visible week count in monthly(0 or null are same with 6).}

\item{isAlways6Week}{Logical. Always show 6 weeks. If false, show 5 weeks or 6 weeks based on the month.}

\item{workweek}{Logical. Show only 5 days except for weekend.}

\item{visibleScheduleCount}{Numeric. The visible schedule count in monthly grid.}

\item{moreLayerSize}{List of parameters, see online documentation.}

\item{grid}{List of parameters, see online documentation.}

\item{scheduleFilter}{List of parameters, see online documentation.}
}
\value{
A \code{calendar} htmlwidget.
}
\description{
Options for monthly view.
}
\note{
Online JavaScript documentation: \url{https://nhn.github.io/tui.calendar/latest/MonthOptions/}
}
\examples{
# Change option for monthly view
calendar(view = "month") \%>\%
  cal_month_options(
    startDayOfWeek = 1,
    daynames = c("Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"),
    narrowWeekend = TRUE
  )
}
