% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_compare.group_tna}
\alias{plot_compare.group_tna}
\title{Plot the difference network between two clusters}
\usage{
\method{plot_compare}{group_tna}(x, i = 1L, j = 2L, ...)
}
\arguments{
\item{x}{A \code{group_tna} object.}

\item{i}{An \code{integer} index or the name of the principal cluster as a
\code{character} string.}

\item{j}{An \code{integer} index or the name of the secondary cluster as a
\code{character} string.}

\item{...}{Additional arguments passed to \code{\link[=plot_compare.tna]{plot_compare.tna()}}.}
}
\value{
A \code{qgraph} object displaying the difference network between the
two clusters
}
\description{
Plot the difference network between two clusters
}
\examples{
model <- group_model(engagement_mmm)
plot_compare(model)

}
\seealso{
Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
