% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmvt.R
\name{rtmvt}
\alias{rtmvt}
\title{Random number generation for truncated multivariate Student's t distribution subject to linear inequality constraints}
\usage{
rtmvt(n, Mean, Sigma, nu, D, lower, upper, int, burn = 10, thin = 1)
}
\arguments{
\item{n}{number of random samples desired (sample size).}

\item{Mean}{location vector of the multivariate Student's t distribution.}

\item{Sigma}{positive definite dispersion matrix of the multivariate t distribution.}

\item{nu}{degrees of freedom for Student-t distribution.}

\item{D}{matrix or vector of coefficients of linear inequality constraints.}

\item{lower}{lower bound vector for truncation.}

\item{upper}{upper bound vector for truncation.}

\item{int}{initial value vector for Gibbs sampler.}

\item{burn}{burn-in iterations decarded (default as \code{10}).}

\item{thin}{thinning lag (default as \code{1}).}
}
\value{
\code{rtmvt} returns a (\code{n*p}) matrix (or vector when \code{n=1}) containing random numbers which follows truncated multivariate Student-t distribution.
}
\description{
\code{rtmvt} simulates truncated multivariate (p-dimensional) Student's t distribution subject to linear inequality constraints. The constraints should be written as a matrix (\code{D}) with \code{lower} and \code{upper} as the lower and upper bounds for those constraints respectively. Note that \code{D} can be non-full rank, which generalizes many traditional methods.
}
\examples{
# Example for full rank
d <- 3
rho <- 0.5
nu <- 10
Sigma <- matrix(0, nrow=d, ncol=d)
Sigma <- rho^abs(row(Sigma) - col(Sigma))

D1 <- diag(1,d) # Full rank

set.seed(1203)
ans.t <- rtmvt(n=1000, Mean=1:d, Sigma, nu=nu, D=D1, lower=rep(-1,d), upper=rep(1,d),
int=rep(0,d), burn=50, thin=0)

acf(ans.t)
apply(ans.t, 2, summary)

}
