% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_map.R
\name{aggregate_map}
\alias{aggregate_map}
\title{Aggregate map}
\usage{
aggregate_map(shp, by = NULL, fact = NULL, agg.fun = NULL,
  weights = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{shp}{shape object, which is one of
\enumerate{
 \item{\code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}
 \item{\code{\link[sp:SpatialLinesDataFrame]{SpatialLines(DataFrame)}}}
 \item{\code{\link[sp:SpatialGridDataFrame]{SpatialGrid(DataFrame)}}}
 \item{\code{\link[sp:SpatialPixelsDataFrame]{SpatialPixels(DataFrame)}}}
 \item{\code{\link[raster:Raster-class]{RasterLayer, RasterStack, or RasterBrick}}}
 \item{\code{sf} object if it can be coerced to a \code{Spatial} object}
}}

\item{by}{variable by which polygons or lines are merged. Does not apply to raster objects.}

\item{fact}{number that specifies how many cells in both horizontal and vertical direction are merged. Only applied to raster objects.}

\item{agg.fun}{aggregation function(s). One of the following formats:
\enumerate{
\item{One function (name) by which all variables are aggregated.}
\item{A vector of two function names called \code{"num"} and \code{"cat"} that determine the functions by which numeric respectively categorical variables are aggregated. For instance \code{c(num="mean", cat="modal")}, which calculates the mean and mode for numeric respectively categorical variables.}
\item{A list where per variable the (names of the) function(s) are provided. The list names should correspond to the variable names.}
}
These predefined functions can be used: \code{"mean"}, \code{"modal"}, \code{"first"}, and \code{"last"}.}

\item{weights}{name of a numeric variable in \code{shp}. The values serve as weights for the aggregation function. If provided, these values are passed on as second argument. Works with aggregation functions \code{"mean"} and \code{"modal"}. Use \code{"AREA"} for polygon area sizes.}

\item{na.rm}{passed on to the aggregation function(s) \code{agg.fun}.}

\item{...}{other arguments passed on to the aggregation function(s) \code{agg.fun}.}
}
\value{
A shape object, in the same format as \code{shp}
}
\description{
Aggregate spatial polygons, spatial lines or raster objects. For spatial polygons and lines, the units will be merged with the \code{by} variable. For rasters, the \code{fact} parameter determined how many rasters cells are aggregated both horizontally and vertically. Per data variable, an aggregation formula can be specified, by default mean for numeric and modal for categorical varaibles.
}
\examples{
\dontrun{
if (require(tmap)) {
    data(land)

    # original map
    qtm(land, raster="cover_cls")

    # map decreased by factor 4 for each dimension
    land4 <- aggregate_map(land, fact=4, agg.fun="modal")
    qtm(land4, raster="cover_cls")

    # map decreased by factor 8, where the variable trees is
    # aggregated with mean, min, and max
    land_trees <- aggregate_map(land, fact=8,
        agg.fun=list(trees="mean", trees="min", trees="max"))

    tm_shape(land_trees) +
    	tm_raster(c("trees.1", "trees.2", "trees.3"), title="Trees (\%)") +
    	tm_facets(free.scales=FALSE) +
    	tm_layout(panel.labels = c("mean", "min", "max"))

    data(NLD_muni, NLD_prov)

    # aggregate Dutch municipalities to provinces
    NLD_prov2 <- aggregate_map(NLD_muni, by="province",
        agg.fun = list(population="sum", origin_native="mean", origin_west="mean",
    				   origin_non_west="mean", name="modal"), weights = "population")

    # see original provinces data
    NLD_prov@data[, c("name", "population", "origin_native", "origin_west", "origin_non_west")]

    # see aggregates data (the last column corresponds to the most populated municipalities)
    NLD_prov2@data

    # largest municipalities in area per province
    aggregate_map(NLD_muni, by="province",
                  agg.fun = list(name="modal"), weights = "AREA")@data
    }
}
}

