% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb.R
\name{bb}
\alias{bb}
\title{Bounding box generator}
\usage{
bb(x = NA, ext = NULL, cx = NULL, cy = NULL, width = NULL,
  height = NULL, xlim = NULL, ylim = NULL, relative = FALSE,
  current.projection = NULL, projection = NULL)
}
\arguments{
\item{x}{One of the following:
\itemize{
\item A shape (from class \code{\link[sp:Spatial]{Spatial}} or \code{\link[raster:Raster-class]{Raster}})
\item A bounding box (either 2 by 2 matrix or an \code{\link[raster:Extent]{Extent}} object). 
\item Open Street Map search query. The bounding is automatically generated by querying \code{q} from Open Street Map Nominatim. See \url{http://wiki.openstreetmap.org/wiki/Nominatim}.}
If \code{x} is not specified, a bounding box can be created from scratch (see details.}

\item{ext}{Extension factor of the bounding box. If 1, the bounding box is unchanged. Values smaller than 1 reduces the bounding box, and values larger than 1 enlarges the bounding box. This argument is a shortcut for both \code{width} and \code{height} with \code{relative=TRUE}. If a negative value is specified, then the shortest side of the bounding box (so width or height) is extended with \code{ext}, and the longest side is extended with the same absolute value. This is especially useful for bounding boxes with very low or high aspect ratios.}

\item{cx}{center x coordinate}

\item{cy}{center y coordinate}

\item{width}{width of the bounding box. These are either absolute or relative (depending on the argument \code{relative}).}

\item{height}{height of the bounding box. These are either absolute or relative (depending on the argument \code{relative}).}

\item{xlim}{limits of the x-axis. These are either absolute or relative (depending on the argument \code{relative}).}

\item{ylim}{limits of the y-axis. See \code{xlim}.}

\item{relative}{boolean that determines whether relative values are used for \code{width}, \code{height}, \code{xlim} and \code{ylim} or absolute. If \code{x} is unspecified, \code{relative} is set to \code{"FALSE"}.}

\item{current.projection}{projection string (see \code{\link{set_projection}}) of the that corresponds to the}

\item{projection}{projection string (see \code{\link{set_projection}}) to transform the bounding box to.}
}
\description{
Swiss army knife for bounding boxes. Modify an existing bounding box or create a new bounding box from scratch. See details.
}
\details{
An existing bounding box (defined by \code{x}) can be modified as follows:
\itemize{
\item Using the extension factor \code{ext}.
\item Changing the width and height with \code{width} and \code{height}. The argument \code{relavitve} determines whether relative or absolute values are used. 
\item Setting the x and y limits. The argument \code{relavitve} determines whether relative or absolute values are used.}

A new bounding box can be created from scratch as follows:
\itemize{
\item Using the extension factor \code{ext}.
\item Setting the center coorinates \code{cx} and \code{cy}, together with the \code{width} and \code{height}.
\item Setting the x and y limits \code{xlim} and \code{ylim}
}
}
\examples{
## load shapes
data(NLD_muni)
data(World)

## get bounding box (similar to sp's function bbox)
bb(NLD_muni)

## extent it by factor 1.10
bb(NLD_muni, ext=1.10)

## convert to longlat
bb(NLD_muni, projection="longlat")

## change existing bounding box
bb(NLD_muni, ext=1.5)
bb(NLD_muni, width=2, relative = TRUE)
bb(NLD_muni, xlim=c(.25, .75), ylim=c(.25, .75), relative = TRUE)
bb("Limburg", projection = get_projection(NLD_muni))

tm_shape(World, bbox=bb("Italy", projection = "eck4")) + tm_polygons()
#identical: tm_shape(World, x="Italy", projection = "eck4") + tm_polygons()

## create new bounding box
tm_shape(NLD_muni, bbox=bb(cx=190000, cy=330000, width=50000, height=50000)) + tm_polygons()
}

