% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_text}
\alias{tm_text}
\title{Add text labels}
\usage{
tm_text(text, cex = 1, root = 3, fontcolor = NA, fontface = "plain",
  fontfamily = "sans", alpha = NA, case = NA, shadow = FALSE,
  bg.color = NA, bg.alpha = NA, cex.lowerbound = 0.4,
  print.tiny = FALSE, scale = 1, xmod = 0, ymod = 0)
}
\arguments{
\item{text}{name of the variable in the shape object that contains the text labels}

\item{cex}{relative size of the text labels (see note). Eiter one number, a name of a numeric variable in the shape data that is used to scale the sizes proportionally, or the value \code{"AREA"}, where the text size is proportional to the area size of the polygons.}

\item{root}{root number to which the font sizes are scaled. Only applicable if \code{cex} is a variable name or \code{"AREA"}. If \code{root=2}, the square root is taken, if \code{root=3}, the cube root etc.}

\item{fontcolor}{color of the text labels}

\item{fontface}{font face of the text labels}

\item{fontfamily}{font family of the text labels}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{fontcolor} is used (normally 1).}

\item{case}{case of the font. Use "upper" to generate upper-case text, "lower" to generate lower-case text, and \code{NA} to leave the text as is.}

\item{shadow}{logical that determines whether a shadow is depicted behind the text. The color of the shadow is either white or yellow, depending of the \code{fontcolor}.}

\item{bg.color}{background color of the text labels. By default, \code{bg.color=NA}, so no background is drawn.}

\item{bg.alpha}{number between 0 and 1 that specifies the transparancy of the text background (0 is totally transparent, 1 is solid background).}

\item{cex.lowerbound}{lowerbound for \code{cex}. Only useful when \code{cex} is not a constant. If \code{print.tiny} is \code{TRUE}, then all text labels which relative text is smaller than \code{cex.lowerbound} are depicted at relative size \code{cex.lowerbound}. If \code{print.tiny} is \code{FALSE}, then text labels are only depicted if their relative sizes are at least \code{cex.lowerbound} (in other words, tiny labels are omitted).}

\item{print.tiny}{boolean, see \code{cex.lowerbound}}

\item{scale}{text size multiplier, useful in case \code{cex} is variable or \code{"AREA"}.}

\item{xmod}{horizontal position modification of the text (relatively): 0 means no modification, and 1 means the total width of the frame. Either a single number for all polygons, or a numeric variable in the shape data specifying a number for each polygon. Together with \code{ymod}, it determines position modification of the text labels. In most coordinate systems (projections), the origin is located at the bottom left, so negative \code{xmod} move the text to the left, and negative \code{ymod} values to the bottom.}

\item{ymod}{vertical position modification. See xmod.}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that adds text labels.
}
\note{
The absolute fontsize (in points) is determined by the (ROOT) viewport, which may depend on the graphics device.
}
\examples{
# World example
data(World)
tm_shape(World) +
	tm_text("name", cex="AREA")

# Europe example
data(Europe)
tm_shape(Europe) +
    tm_fill() +
    tm_borders() +
    tm_text("iso_a3", cex="AREA", root=4, shadow = TRUE, fontcolor = "grey20", scale=2, 
			cex.lowerbound = .1) +
tm_shape(Europe) +
	tm_text("name", cex="AREA", root=4, scale=1, 
			ymod=-.04 * approx_areas(Europe, units = "norm")^(1/4))
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

