% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tm_borders}
\alias{tm_borders}
\title{Draw polygon borders}
\usage{
tm_borders(col = "grey40", lwd = 1, lty = "solid")
}
\arguments{
\item{col}{line color}

\item{lwd}{line width (see \code{\link[graphics:par]{par}})}

\item{lty}{line type (see \code{\link[graphics:par]{par}})}
}
\value{
\code{\link{tmap-element}}
}
\description{
This layer defines the borders of the polygons. Color, line width and line type can be set.
}
\examples{
## Europe example
data(Europe)
tm_shape(Europe) + tm_borders()

## Netherlands example
data(NLD_prov)
data(NLD_muni)

tm_shape(NLD_prov) + 
    tm_fill("name") + 
tm_shape(NLD_muni) + 
    tm_borders() + 
tm_shape(NLD_prov) + 
    tm_borders(lwd=2) +
    tm_text("name") +
tm_layout_NLD("Provinces and municipalities", legend.show=FALSE)
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

